from matplotlib import pyplot as plt
import pandas as pd

plt.style.use("seaborn")

# top 200 trending videos
data = pd.read_csv('views-likes.csv')
view_count = data['view_count']
likes = data['likes']
ratio = data['ratio']

# we can use ratio for the colormap
plt.scatter(view_count, likes, c=ratio, cmap="summer",
            edgecolor='black', linewidths=1, alpha=0.75)
# place a color bar so we now what this represents
cbar = plt.colorbar()
cbar.set_label("Like/Dislike ratio")

# use log axis to deminish the effect of outliers
plt.xscale('log')
plt.yscale('log')

plt.title("Trending Youtube Videos")
plt.xlabel("View count")
plt.ylabel("Total likes")

plt.tight_layout()
plt.show()
